//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Reflection;

public class ReflectionTest
{
    private int fielda;
    private float fieldb;
    private string fieldc;
    ReflectionTest()
    {
       fielda = 0;
       fieldb = 0;
       fieldc = "";
    }
    ReflectionTest(int a, float b, String c)
    {
        fielda = a;
        fieldb = b;
        fieldc = c;
        return;
    }
    int getfielda()
    {
        return fielda;
    }
    float getfieldb()
    {
        return fieldb;
    }
    string getfieldc()
    {
        return fieldc;
    }
    int add(int a)
    {
        return a + fielda;
    }
    float add(float b)
    {
        return b + fieldb;
    }
    string add(string c)
    {
        return c + fieldc;
    }
    void Reflect()
    {
        try
        {
			Type t = GetType();
			Console.WriteLine("> " + t.BaseType.Name + " metody");
            MethodInfo [] methods = t.BaseType.GetMethods(BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            for(int i = 0; i < methods.Length; i++)
            {
				Console.Write("   " + methods[i].Name);
				ParameterInfo [] p = methods[i].GetParameters();
				Console.Write("(");
				for(int j = 0; j < p.Length; j++)
					if(j != p.Length - 1)
						Console.Write(p[j].ParameterType + ", ");
					else
						Console.Write(p[j].ParameterType);
				Console.WriteLine(") ");
			}
            Console.WriteLine("> " + t.Name + " metody");
			methods = t.GetMethods(BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
			for(int i = 0; i < methods.Length; i++)
            {
				Console.Write("   " + methods[i].Name);
				ParameterInfo [] p = methods[i].GetParameters();
				Console.Write("(");
				for(int j = 0; j < p.Length; j++)
					if(j != p.Length - 1)
						Console.Write(p[j].ParameterType + ", ");
					else
						Console.Write(p[j].ParameterType);
				Console.WriteLine(") ");
			}
            Console.WriteLine("> " + t.BaseType.Name + " konstruktory");
            ConstructorInfo [] constructors = t.BaseType.GetConstructors(BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            foreach(ConstructorInfo ci in constructors)
            {
                Console.Write("   " + ci.Name);
                Console.Write("(");
                foreach(ParameterInfo p in ci.GetParameters())
                    Console.Write(p.ParameterType + " ");
                Console.WriteLine(") ");
            }
            Console.WriteLine("> " + t.Name + " konstruktory");
            constructors = t.GetConstructors(BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
			foreach(ConstructorInfo ci in constructors)
			{
				Console.Write("   " + ci.Name);
				Console.Write("(");
				foreach(ParameterInfo p in ci.GetParameters())
					Console.Write(p.ParameterType + " ");
				Console.WriteLine(") ");
			}
			Console.WriteLine("> " + t.BaseType.Name + " pola");
            FieldInfo [] fields = t.BaseType.GetFields(BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            for(int i = 0; i < fields.Length; i++)
            {
                Console.WriteLine("   " + fields[i].FieldType + " " + fields[i].Name);
            }
            Console.WriteLine("> " + t.Name + " pola");
            fields = t.GetFields(BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            for(int i = 0; i < fields.Length; i++)
            {
                Console.WriteLine("   " + fields[i].FieldType + " " + fields[i].Name);
            }
		}
        catch(Exception e)
        {
            Console.WriteLine(e);
        }
    }
    public static void Main(String[] args)
    {
        ReflectionTest r = new ReflectionTest(1, 2F, "To jest test");
        r.Reflect();
    }
}
